﻿#UNICOPE Registry Key Checker für CITRIX ICA Integration



$regkeys = @(
    [pscustomobject]@{path="HKLM:\SOFTWARE\WOW6432Node\Citrix\ICA Client\Engine\Configuration\Advanced\Modules\VDMFME"; name="Port"; data="49671"}
    [pscustomobject]@{path="HKLM:\SOFTWARE\WOW6432Node\Citrix\ICA Client\Engine\Configuration\Advanced\Modules\VDMFME"; name="LogPath"; data="C:\\ProgramData\\UNICOPE\\MFME\\log"}
    [pscustomobject]@{path="HKLM:\SOFTWARE\WOW6432Node\Citrix\ICA Client\Engine\Configuration\Advanced\Modules\VDMFME"; name="EnableLog"; data="True"}
    [pscustomobject]@{path="HKLM:\SOFTWARE\WOW6432Node\Citrix\ICA Client\Engine\Configuration\Advanced\Modules\VDMFME"; name="DriverNameWin32"; data="VDMFME.DLL"}
    [pscustomobject]@{path="HKLM:\SOFTWARE\WOW6432Node\Citrix\ICA Client\Engine\Configuration\Advanced\Modules\VDMFME"; name="DriverNameWin16"; data="Unsupported"}
    [pscustomobject]@{path="HKLM:\SOFTWARE\WOW6432Node\Citrix\ICA Client\Engine\Configuration\Advanced\Modules\VDMFME"; name="DriverName"; data="Unsupported"}
    [pscustomobject]@{path="HKLM:\SOFTWARE\WOW6432Node\Citrix\ICA Client\Engine\Configuration\Advanced\Modules\ICA 3.0"; name="VirtualDriverEx"; data="VDMFME"}
)


foreach($regkey in $regkeys) {
    Write-Host "Checking UC-ICA registry path" $regkey.path
    if(!(Test-Path -Path $regkey.path)) {
        Write-Warning "registry path not found, creating..."
        New-Item -Path $regkey.path -Force
    }

    try{  
        Write-Host "Checking UC-ICA registry key" $regkey.name
        Get-ItemProperty -Path $regkey.path -Name $regkey.name -ErrorAction Stop
        Write-Host "registry key exists" 
    }  
    catch [System.Management.Automation.PSArgumentException] {  
        Write-Warning "registry key not found, adding ..."  
        New-ItemProperty -Path $regkey.path -Name $regkey.name -Value $regkey.data -Force  
    }  
    catch {
        Write-Warning "registry key not found, adding forced"  
        New-ItemProperty -Path $regkey.path -Name $regkey.name -Value $regkey.data -Type String -Force  
    }

}

Write-Host "Check regsistry keys is done."
  