/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.pool;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionFactory;
import org.apache.http.HttpHost;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.DefaultBHttpClientConnection;
import org.apache.http.impl.DefaultBHttpClientConnectionFactory;
import org.apache.http.params.HttpParamConfig;
import org.apache.http.params.HttpParams;
import org.apache.http.pool.ConnFactory;
import org.apache.http.util.Args;

public class BasicConnFactory
implements ConnFactory<HttpHost, HttpClientConnection> {
    private final SocketFactory plainfactory;
    private final SSLSocketFactory sslfactory;
    private final int connectTimeout;
    private final SocketConfig sconfig;
    private final HttpConnectionFactory<? extends HttpClientConnection> connFactory;

    public BasicConnFactory(SSLSocketFactory sSLSocketFactory, HttpParams httpParams) {
        Args.notNull(httpParams, "HTTP params");
        this.plainfactory = null;
        this.sslfactory = sSLSocketFactory;
        this.connectTimeout = httpParams.getIntParameter("http.connection.timeout", 0);
        this.sconfig = HttpParamConfig.getSocketConfig(httpParams);
        this.connFactory = new DefaultBHttpClientConnectionFactory(HttpParamConfig.getConnectionConfig(httpParams));
    }

    public BasicConnFactory(HttpParams httpParams) {
        this(null, httpParams);
    }

    public BasicConnFactory(SocketFactory socketFactory, SSLSocketFactory sSLSocketFactory, int n2, SocketConfig socketConfig, ConnectionConfig connectionConfig) {
        this.plainfactory = socketFactory;
        this.sslfactory = sSLSocketFactory;
        this.connectTimeout = n2;
        this.sconfig = socketConfig != null ? socketConfig : SocketConfig.DEFAULT;
        this.connFactory = new DefaultBHttpClientConnectionFactory(connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT);
    }

    public BasicConnFactory(int n2, SocketConfig socketConfig, ConnectionConfig connectionConfig) {
        this(null, null, n2, socketConfig, connectionConfig);
    }

    public BasicConnFactory(SocketConfig socketConfig, ConnectionConfig connectionConfig) {
        this(null, null, 0, socketConfig, connectionConfig);
    }

    public BasicConnFactory() {
        this(null, null, 0, SocketConfig.DEFAULT, ConnectionConfig.DEFAULT);
    }

    protected HttpClientConnection create(Socket socket, HttpParams httpParams) {
        int n2 = httpParams.getIntParameter("http.socket.buffer-size", 8192);
        DefaultBHttpClientConnection defaultBHttpClientConnection = new DefaultBHttpClientConnection(n2);
        defaultBHttpClientConnection.bind(socket);
        return defaultBHttpClientConnection;
    }

    @Override
    public HttpClientConnection create(HttpHost httpHost) {
        String string = httpHost.getSchemeName();
        Socket socket = null;
        if ("http".equalsIgnoreCase(string)) {
            Socket socket2 = socket = this.plainfactory != null ? this.plainfactory.createSocket() : new Socket();
        }
        if ("https".equalsIgnoreCase(string)) {
            socket = (this.sslfactory != null ? this.sslfactory : SSLSocketFactory.getDefault()).createSocket();
        }
        if (socket == null) {
            throw new IOException(string + " scheme is not supported");
        }
        String string2 = httpHost.getHostName();
        int n2 = httpHost.getPort();
        if (n2 == -1) {
            if (httpHost.getSchemeName().equalsIgnoreCase("http")) {
                n2 = 80;
            } else if (httpHost.getSchemeName().equalsIgnoreCase("https")) {
                n2 = 443;
            }
        }
        socket.setSoTimeout(this.sconfig.getSoTimeout());
        if (this.sconfig.getSndBufSize() > 0) {
            socket.setSendBufferSize(this.sconfig.getSndBufSize());
        }
        if (this.sconfig.getRcvBufSize() > 0) {
            socket.setReceiveBufferSize(this.sconfig.getRcvBufSize());
        }
        socket.setTcpNoDelay(this.sconfig.isTcpNoDelay());
        int n3 = this.sconfig.getSoLinger();
        if (n3 >= 0) {
            socket.setSoLinger(true, n3);
        }
        socket.setKeepAlive(this.sconfig.isSoKeepAlive());
        socket.connect(new InetSocketAddress(string2, n2), this.connectTimeout);
        return this.connFactory.createConnection(socket);
    }
}

