/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.impl.client.cache.CacheEntity;
import org.apache.http.impl.client.cache.CacheValidityPolicy;
import org.apache.http.impl.client.cache.Proxies;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;

class CachedHttpResponseGenerator {
    private final CacheValidityPolicy validityStrategy;

    CachedHttpResponseGenerator(CacheValidityPolicy cacheValidityPolicy) {
        this.validityStrategy = cacheValidityPolicy;
    }

    CachedHttpResponseGenerator() {
        this(new CacheValidityPolicy());
    }

    CloseableHttpResponse generateResponse(HttpRequestWrapper httpRequestWrapper, HttpCacheEntry httpCacheEntry) {
        long l2;
        Date date = new Date();
        BasicHttpResponse basicHttpResponse = new BasicHttpResponse(HttpVersion.HTTP_1_1, httpCacheEntry.getStatusCode(), httpCacheEntry.getReasonPhrase());
        basicHttpResponse.setHeaders(httpCacheEntry.getAllHeaders());
        if (this.responseShouldContainEntity(httpRequestWrapper, httpCacheEntry)) {
            CacheEntity cacheEntity = new CacheEntity(httpCacheEntry);
            this.addMissingContentLengthHeader(basicHttpResponse, cacheEntity);
            basicHttpResponse.setEntity(cacheEntity);
        }
        if ((l2 = this.validityStrategy.getCurrentAgeSecs(httpCacheEntry, date)) > 0L) {
            if (l2 >= Integer.MAX_VALUE) {
                basicHttpResponse.setHeader("Age", "2147483648");
            } else {
                basicHttpResponse.setHeader("Age", "" + (int)l2);
            }
        }
        return Proxies.enhanceResponse(basicHttpResponse);
    }

    CloseableHttpResponse generateNotModifiedResponse(HttpCacheEntry httpCacheEntry) {
        Header header;
        Header header2;
        Header header3;
        Header header4;
        BasicHttpResponse basicHttpResponse = new BasicHttpResponse(HttpVersion.HTTP_1_1, 304, "Not Modified");
        Header header5 = httpCacheEntry.getFirstHeader("Date");
        if (header5 == null) {
            header5 = new BasicHeader("Date", DateUtils.formatDate(new Date()));
        }
        basicHttpResponse.addHeader(header5);
        Header header6 = httpCacheEntry.getFirstHeader("ETag");
        if (header6 != null) {
            basicHttpResponse.addHeader(header6);
        }
        if ((header4 = httpCacheEntry.getFirstHeader("Content-Location")) != null) {
            basicHttpResponse.addHeader(header4);
        }
        if ((header3 = httpCacheEntry.getFirstHeader("Expires")) != null) {
            basicHttpResponse.addHeader(header3);
        }
        if ((header2 = httpCacheEntry.getFirstHeader("Cache-Control")) != null) {
            basicHttpResponse.addHeader(header2);
        }
        if ((header = httpCacheEntry.getFirstHeader("Vary")) != null) {
            basicHttpResponse.addHeader(header);
        }
        return Proxies.enhanceResponse(basicHttpResponse);
    }

    private void addMissingContentLengthHeader(HttpResponse httpResponse, HttpEntity httpEntity) {
        if (this.transferEncodingIsPresent(httpResponse)) {
            return;
        }
        Header header = httpResponse.getFirstHeader("Content-Length");
        if (header == null) {
            header = new BasicHeader("Content-Length", Long.toString(httpEntity.getContentLength()));
            httpResponse.setHeader(header);
        }
    }

    private boolean transferEncodingIsPresent(HttpResponse httpResponse) {
        Header header = httpResponse.getFirstHeader("Transfer-Encoding");
        return header != null;
    }

    private boolean responseShouldContainEntity(HttpRequestWrapper httpRequestWrapper, HttpCacheEntry httpCacheEntry) {
        return httpRequestWrapper.getRequestLine().getMethod().equals("GET") && httpCacheEntry.getResource() != null;
    }
}

