/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CacheMap;

public class BasicHttpCacheStorage
implements HttpCacheStorage {
    private final CacheMap entries;

    public BasicHttpCacheStorage(CacheConfig cacheConfig) {
        this.entries = new CacheMap(cacheConfig.getMaxCacheEntries());
    }

    @Override
    public synchronized void putEntry(String string, HttpCacheEntry httpCacheEntry) {
        this.entries.put(string, httpCacheEntry);
    }

    @Override
    public synchronized HttpCacheEntry getEntry(String string) {
        return (HttpCacheEntry)this.entries.get(string);
    }

    @Override
    public synchronized void removeEntry(String string) {
        this.entries.remove(string);
    }

    @Override
    public synchronized void updateEntry(String string, HttpCacheUpdateCallback httpCacheUpdateCallback) {
        HttpCacheEntry httpCacheEntry = (HttpCacheEntry)this.entries.get(string);
        this.entries.put(string, httpCacheUpdateCallback.update(httpCacheEntry));
    }
}

