/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.TokenIterator;
import org.apache.http.message.BasicHeaderIterator;
import org.apache.http.message.BasicTokenIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

public class DefaultConnectionReuseStrategy
implements ConnectionReuseStrategy {
    public static final DefaultConnectionReuseStrategy INSTANCE = new DefaultConnectionReuseStrategy();

    @Override
    public boolean keepAlive(HttpResponse httpResponse, HttpContext httpContext) {
        int n2;
        Object object;
        Header[] headerArray;
        ProtocolVersion protocolVersion;
        block15: {
            Args.notNull(httpResponse, "HTTP response");
            Args.notNull(httpContext, "HTTP context");
            protocolVersion = httpResponse.getStatusLine().getProtocolVersion();
            Header header = httpResponse.getFirstHeader("Transfer-Encoding");
            if (header != null) {
                if (!"chunked".equalsIgnoreCase(header.getValue())) {
                    return false;
                }
            } else if (this.canResponseHaveBody(httpResponse)) {
                headerArray = httpResponse.getHeaders("Content-Length");
                if (headerArray.length == 1) {
                    object = headerArray[0];
                    try {
                        n2 = Integer.parseInt(object.getValue());
                        if (n2 < 0) {
                            return false;
                        }
                        break block15;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                return false;
            }
        }
        if ((headerArray = httpResponse.getHeaders("Connection")).length == 0) {
            headerArray = httpResponse.getHeaders("Proxy-Connection");
        }
        if (headerArray.length != 0) {
            try {
                object = new BasicTokenIterator(new BasicHeaderIterator(headerArray, null));
                n2 = 0;
                while (object.hasNext()) {
                    String string = object.nextToken();
                    if ("Close".equalsIgnoreCase(string)) {
                        return false;
                    }
                    if (!"Keep-Alive".equalsIgnoreCase(string)) continue;
                    n2 = 1;
                }
                if (n2 != 0) {
                    return true;
                }
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return !protocolVersion.lessEquals(HttpVersion.HTTP_1_0);
    }

    protected TokenIterator createTokenIterator(HeaderIterator headerIterator) {
        return new BasicTokenIterator(headerIterator);
    }

    private boolean canResponseHaveBody(HttpResponse httpResponse) {
        int n2 = httpResponse.getStatusLine().getStatusCode();
        return n2 >= 200 && n2 != 204 && n2 != 304 && n2 != 205;
    }
}

