/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.InternalByteArrayEntity;
import org.apache.http.client.fluent.InternalEntityEnclosingHttpRequest;
import org.apache.http.client.fluent.InternalFileEntity;
import org.apache.http.client.fluent.InternalHttpRequest;
import org.apache.http.client.fluent.InternalInputStreamEntity;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HttpContext;

public class Request {
    public static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final Locale DATE_LOCALE = Locale.US;
    public static final TimeZone TIME_ZONE = TimeZone.getTimeZone("GMT");
    private final InternalHttpRequest request;
    private Boolean useExpectContinue;
    private Integer socketTmeout;
    private Integer connectTimeout;
    private HttpHost proxy;
    private SimpleDateFormat dateFormatter;

    public static Request Get(URI uRI) {
        return new Request(new InternalHttpRequest("GET", uRI));
    }

    public static Request Get(String string) {
        return new Request(new InternalHttpRequest("GET", URI.create(string)));
    }

    public static Request Head(URI uRI) {
        return new Request(new InternalHttpRequest("HEAD", uRI));
    }

    public static Request Head(String string) {
        return new Request(new InternalHttpRequest("HEAD", URI.create(string)));
    }

    public static Request Post(URI uRI) {
        return new Request(new InternalEntityEnclosingHttpRequest("POST", uRI));
    }

    public static Request Post(String string) {
        return new Request(new InternalEntityEnclosingHttpRequest("POST", URI.create(string)));
    }

    public static Request Patch(URI uRI) {
        return new Request(new InternalEntityEnclosingHttpRequest("PATCH", uRI));
    }

    public static Request Patch(String string) {
        return new Request(new InternalEntityEnclosingHttpRequest("PATCH", URI.create(string)));
    }

    public static Request Put(URI uRI) {
        return new Request(new InternalEntityEnclosingHttpRequest("PUT", uRI));
    }

    public static Request Put(String string) {
        return new Request(new InternalEntityEnclosingHttpRequest("PUT", URI.create(string)));
    }

    public static Request Trace(URI uRI) {
        return new Request(new InternalHttpRequest("TRACE", uRI));
    }

    public static Request Trace(String string) {
        return new Request(new InternalHttpRequest("TRACE", URI.create(string)));
    }

    public static Request Delete(URI uRI) {
        return new Request(new InternalHttpRequest("DELETE", uRI));
    }

    public static Request Delete(String string) {
        return new Request(new InternalHttpRequest("DELETE", URI.create(string)));
    }

    public static Request Options(URI uRI) {
        return new Request(new InternalHttpRequest("OPTIONS", uRI));
    }

    public static Request Options(String string) {
        return new Request(new InternalHttpRequest("OPTIONS", URI.create(string)));
    }

    Request(InternalHttpRequest internalHttpRequest) {
        this.request = internalHttpRequest;
    }

    HttpResponse internalExecute(HttpClient httpClient, HttpContext httpContext) {
        RequestConfig.Builder builder = httpClient instanceof Configurable ? RequestConfig.copy(((Configurable)((Object)httpClient)).getConfig()) : RequestConfig.custom();
        if (this.useExpectContinue != null) {
            builder.setExpectContinueEnabled(this.useExpectContinue);
        }
        if (this.socketTmeout != null) {
            builder.setSocketTimeout(this.socketTmeout);
        }
        if (this.connectTimeout != null) {
            builder.setConnectTimeout(this.connectTimeout);
        }
        if (this.proxy != null) {
            builder.setProxy(this.proxy);
        }
        RequestConfig requestConfig = builder.build();
        this.request.setConfig(requestConfig);
        return httpClient.execute((HttpUriRequest)this.request, httpContext);
    }

    public Response execute() {
        return new Response(this.internalExecute(Executor.CLIENT, null));
    }

    public void abort() {
        this.request.abort();
    }

    public Request addHeader(Header header) {
        this.request.addHeader(header);
        return this;
    }

    public Request setHeader(Header header) {
        this.request.setHeader(header);
        return this;
    }

    public Request addHeader(String string, String string2) {
        this.request.addHeader(string, string2);
        return this;
    }

    public Request setHeader(String string, String string2) {
        this.request.setHeader(string, string2);
        return this;
    }

    public Request removeHeader(Header header) {
        this.request.removeHeader(header);
        return this;
    }

    public Request removeHeaders(String string) {
        this.request.removeHeaders(string);
        return this;
    }

    public Request setHeaders(Header ... headerArray) {
        this.request.setHeaders(headerArray);
        return this;
    }

    public Request setCacheControl(String string) {
        this.request.setHeader("Cache-Control", string);
        return this;
    }

    private SimpleDateFormat getDateFormat() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new SimpleDateFormat(DATE_FORMAT, DATE_LOCALE);
            this.dateFormatter.setTimeZone(TIME_ZONE);
        }
        return this.dateFormatter;
    }

    public Request setDate(Date date) {
        this.request.setHeader("Date", this.getDateFormat().format(date));
        return this;
    }

    public Request setIfModifiedSince(Date date) {
        this.request.setHeader("If-Modified-Since", this.getDateFormat().format(date));
        return this;
    }

    public Request setIfUnmodifiedSince(Date date) {
        this.request.setHeader("If-Unmodified-Since", this.getDateFormat().format(date));
        return this;
    }

    public Request config(String string, Object object) {
        return this;
    }

    public Request removeConfig(String string) {
        return this;
    }

    public Request version(HttpVersion httpVersion) {
        this.request.setProtocolVersion(httpVersion);
        return this;
    }

    public Request elementCharset(String string) {
        return this;
    }

    public Request useExpectContinue() {
        this.useExpectContinue = Boolean.TRUE;
        return this;
    }

    public Request userAgent(String string) {
        this.request.setHeader("User-Agent", string);
        return this;
    }

    public Request socketTimeout(int n2) {
        this.socketTmeout = n2;
        return this;
    }

    public Request connectTimeout(int n2) {
        this.connectTimeout = n2;
        return this;
    }

    public Request staleConnectionCheck(boolean bl) {
        return this;
    }

    public Request viaProxy(HttpHost httpHost) {
        this.proxy = httpHost;
        return this;
    }

    public Request viaProxy(String string) {
        this.proxy = HttpHost.create(string);
        return this;
    }

    public Request body(HttpEntity httpEntity) {
        if (!(this.request instanceof HttpEntityEnclosingRequest)) {
            throw new IllegalStateException(this.request.getMethod() + " request cannot enclose an entity");
        }
        ((HttpEntityEnclosingRequest)((Object)this.request)).setEntity(httpEntity);
        return this;
    }

    public Request bodyForm(Iterable<? extends NameValuePair> iterable, Charset charset) {
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        for (NameValuePair object2 : iterable) {
            arrayList.add(object2);
        }
        ContentType contentType = ContentType.create("application/x-www-form-urlencoded", charset);
        String string = URLEncodedUtils.format(arrayList, charset != null ? charset.name() : null);
        return this.bodyString(string, contentType);
    }

    public Request bodyForm(Iterable<? extends NameValuePair> iterable) {
        return this.bodyForm(iterable, Consts.ISO_8859_1);
    }

    public Request bodyForm(NameValuePair ... nameValuePairArray) {
        return this.bodyForm(Arrays.asList(nameValuePairArray), Consts.ISO_8859_1);
    }

    public Request bodyString(String string, ContentType contentType) {
        Charset charset = contentType != null ? contentType.getCharset() : null;
        byte[] byArray = charset != null ? string.getBytes(charset) : string.getBytes();
        return this.body(new InternalByteArrayEntity(byArray, contentType));
    }

    public Request bodyFile(File file, ContentType contentType) {
        return this.body(new InternalFileEntity(file, contentType));
    }

    public Request bodyByteArray(byte[] byArray) {
        return this.body(new InternalByteArrayEntity(byArray));
    }

    public Request bodyByteArray(byte[] byArray, ContentType contentType) {
        return this.body(new InternalByteArrayEntity(byArray, contentType));
    }

    public Request bodyByteArray(byte[] byArray, int n2, int n3) {
        return this.body(new InternalByteArrayEntity(byArray, n2, n3));
    }

    public Request bodyByteArray(byte[] byArray, int n2, int n3, ContentType contentType) {
        return this.body(new InternalByteArrayEntity(byArray, n2, n3, contentType));
    }

    public Request bodyStream(InputStream inputStream) {
        return this.body(new InternalInputStreamEntity(inputStream, -1L, null));
    }

    public Request bodyStream(InputStream inputStream, ContentType contentType) {
        return this.body(new InternalInputStreamEntity(inputStream, -1L, contentType));
    }

    public String toString() {
        return this.request.getRequestLine().toString();
    }
}

