/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;

class InternalByteArrayEntity
extends AbstractHttpEntity
implements Cloneable {
    private final byte[] b;
    private final int off;
    private final int len;

    public InternalByteArrayEntity(byte[] byArray, ContentType contentType) {
        Args.notNull(byArray, "Source byte array");
        this.b = byArray;
        this.off = 0;
        this.len = this.b.length;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public InternalByteArrayEntity(byte[] byArray, int n2, int n3, ContentType contentType) {
        Args.notNull(byArray, "Source byte array");
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("off: " + n2 + " len: " + n3 + " b.length: " + byArray.length);
        }
        this.b = byArray;
        this.off = n2;
        this.len = n3;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public InternalByteArrayEntity(byte[] byArray) {
        this(byArray, null);
    }

    public InternalByteArrayEntity(byte[] byArray, int n2, int n3) {
        this(byArray, n2, n3, null);
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        return this.len;
    }

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(this.b, this.off, this.len);
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        Args.notNull(outputStream, "Output stream");
        outputStream.write(this.b, this.off, this.len);
        outputStream.flush();
    }

    @Override
    public boolean isStreaming() {
        return false;
    }
}

