/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.entity;

import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class DeflateInputStream
extends InputStream {
    private final InputStream sourceStream;

    public DeflateInputStream(InputStream inputStream) {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 2);
        int n2 = pushbackInputStream.read();
        int n3 = pushbackInputStream.read();
        if (n2 == -1 || n3 == -1) {
            throw new ZipException("Unexpected end of stream");
        }
        pushbackInputStream.unread(n3);
        pushbackInputStream.unread(n2);
        boolean bl = true;
        int n4 = n2 & 0xFF;
        int n5 = n4 & 0xF;
        int n6 = n4 >> 4 & 0xF;
        int n7 = n3 & 0xFF;
        if (n5 == 8 && n6 <= 7 && (n4 << 8 | n7) % 31 == 0) {
            bl = false;
        }
        this.sourceStream = new DeflateStream(pushbackInputStream, new Inflater(bl));
    }

    @Override
    public int read() {
        return this.sourceStream.read();
    }

    @Override
    public int read(byte[] byArray) {
        return this.sourceStream.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        return this.sourceStream.read(byArray, n2, n3);
    }

    @Override
    public long skip(long l2) {
        return this.sourceStream.skip(l2);
    }

    @Override
    public int available() {
        return this.sourceStream.available();
    }

    @Override
    public void mark(int n2) {
        this.sourceStream.mark(n2);
    }

    @Override
    public void reset() {
        this.sourceStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.sourceStream.markSupported();
    }

    @Override
    public void close() {
        this.sourceStream.close();
    }

    static class DeflateStream
    extends InflaterInputStream {
        private boolean closed = false;

        public DeflateStream(InputStream inputStream, Inflater inflater) {
            super(inputStream, inflater);
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.inf.end();
            super.close();
        }
    }
}

